<?php
/**************************************************************
 * Nome:    CCRelat
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-08-31 (V1.0.0)
 * Descr.:  Relatorios
 *************************************************************/


/**************************************************************
  Area dos includes
 *************************************************************/
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.cc.php');
  $Modulo = $DirCCen;
  include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
  include_once($DirRaiz.$Modulo.$DirModul.'ccger.modu.php');
  include_once($DirRaiz.$DirModul.'geral.modu.php');


/**************************************************************
  Definicao de variaveis
 *************************************************************/
  $Moni  = new Monitores;  // Objeto monitor
  $L_var = $_POST;         // Recebe as variaveis do formulario


/**************************************************************
  Programa Principal
 *************************************************************/
  $Arquivo = brancos_por_sublinhado($L_var['t'].' '.$L_var['m'].'.xls');
  $Arqu    = cria_arquivo_excel($Arquivo);
  for ($x=0; $x<$L_var['tg']; $x++) $LFilas[$x] = $L_var['g'.$x];
  $Imprime =  planilha_filas_dia($LFilas,$L_var['d'],$L_var['a'],$L_var['tp'],$L_var['na'],'xls',$L_var['tcf'], $L_var['filuf']);
  echo planilha_filas_dia($LFilas,$L_var['d'],$L_var['a'],$L_var['tp'],$L_var['na'],'html',$L_var['tcf'], $L_var['filuf'])."<br/><br/>";
  if ($Arqu) {
    fwrite($Arqu, $Imprime);
    fecha_arquivo_excel($Arqu);
  }
  return;



/**************************************************************
  Funcao planilha_filas_dia
 *************************************************************/
function planilha_filas_dia($Filas,$Per_d, $Per_a, $Tipo_per, $MinimoEspera, $Formato, $tempoCon, $ufs) {
    global $Moni;
    $dataAtual = date("d/m/Y");
    $hoje = 0;
    $Saida_tst = "";
    $ufs = explode(",", $ufs);
    
    $Totaldiasmensais=array(31,29,31,30,31,30,31,31,30,31,30,31);
    //Arrumada as datas para timestamp
    list ($data_d, $horario_d) = explode (' ', $Per_d); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d); list ($hora_d, $minuto_d) = explode (':', $horario_d);
    if($dataAtual == $data_d) $hoje = 1;
    list ($data_a, $horario_a) = explode (' ', $Per_a); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a); list ($hora_a, $minuto_a) = explode (':', $horario_a);
    if(($dataAtual != $data_a) || ($hoje != 1)) $hoje = 0;
    $Auy_d = mktime($hora_d, $minuto_d, 0, $mes_d, $dia_d, $ano_d); // $Aux_d = $ano_d.'-'.$mes_d.'-'.$dia_d.' '.$hora_d.':'.$minuto_d;
    $Auy_a = mktime($hora_a, $minuto_a, 0, $mes_a, $dia_a, $ano_a); // $Aux_a = $ano_a.'-'.$mes_a.'-'.$dia_a.' '.$hora_a.':'.$minuto_a;
    if (!($Auy_d) || ($Auy_d<0)) return "Perodo invlido";
    if (!($Auy_a) || ($Auy_a<0)) return "Perodo invlido";
    if ($Auy_d > $Auy_a) return "Perodo invlido";
    $anos=$ano_d;
    $Tabela=$Tab1=$Tab2=array();
    $Saida  = '';

    for ($F=0; $F<count($Filas); $F++) {
        $anos=$ano_d;
        while ($anos<=$ano_a) {
            $meses=$mes_d;
            while ( ($meses<=$mes_a) && ($anos<=$ano_a) ) {
                if ($meses==$mes_d) $dia_d1 = $dia_d;
                else $dia_d1 = '01';
                if ($meses==$mes_a) $dia_a1 = $dia_a;
                else $dia_a1 = $Totaldiasmensais[$meses-1];

                for ($dias=$dia_d1; $dias<=$dia_a1; $dias++) {
                    if ($Tipo_per=="E") {
                        $Vale = monta_horario_expediente($ano_d.'-'.$meses.'-'.$dias,$Filas[$F]);
                        if (!$Vale) continue;
                        $h1 = explode(":",$Vale[0]); $hora_ini = $h1[0]; $minuto_ini = $h1[1];
                        $h2 = explode(":",$Vale[1]); $hora_fim = $h2[0]; $minuto_fim = $h2[1];
                    } elseif ($Tipo_per=="T") {
                        if (($meses==$mes_d) && ($dias==$dia_d)) {
                            $hora_ini = $hora_d; $minuto_ini = $minuto_d;
                        } else {
                            $hora_ini = '00'; $minuto_ini = '00';
                        }
                        
                        if (($meses==$mes_a) && ($dias==$dia_a)) {
                            $hora_fim = $hora_a; $minuto_fim = $minuto_a;
                        } else {
                            $hora_fim = '23'; $minuto_fim = '59';
                        }
                    } else {
                        $hora_ini = $hora_d; $minuto_ini = $minuto_d;
                        $hora_fim = $hora_a; $minuto_fim = $minuto_a;
                    }

                    $Aux_d = $ano_d.'-'.$meses.'-'.$dias.' '.$hora_ini.':'.$minuto_ini;
                    $Aux_a = $ano_a.'-'.$meses.'-'.$dias.' '.$hora_fim.':'.$minuto_fim;
                    
                    $dias = intval($dias,10);

                    if($hoje == 0) $Tab1 = $Moni->relatorio_filas_geral($Filas[$F], $Aux_d, $Aux_a, $MinimoEspera, '', 'relat', $tempoCon, '');
                    if($hoje == 1) $Tab1 = $Moni->relatorio_filas_geral($Filas[$F], $Aux_d, $Aux_a, $MinimoEspera, 'hoje', 'monit', $tempoCon, '');

                    $Tabela[$Filas[$F]]['Ano'][intval($ano_d, 10)]['Mes'][intval($meses, 10)]['Dia'][intval($dias, 10)] = $Tab1;
                }

                $meses++;
                if ($meses==13) {
                    $meses=1;
                    $anos++;
                }
            }
            $anos++;
        }
    }
                
    if ($Formato=="html") {
        $Saida .= '<p class="reltit">Relatrio de atendimentos por dia'."</p>\n";
        $Saida .= '<p class="relper">Perodo: &nbsp;&nbsp;'.substr($Per_d,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($Per_a,0,16)."</p>\n";
    } elseif ($Formato=="xls") {
        $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;">';
        $Saida .= '<tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Relat&oacute;rio de atendimentos por dia';
        $Saida .= '</td></tr><tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Per&iacute;odo: &nbsp;&nbsp;'.substr($Per_d,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($Per_a,0,16);
        $Saida .= '</td></tr>';
    }

    $Saida .= monta_relatorio_planilha_filas_dia($Filas, $Tabela, $Per_d, $Per_a, $Formato);

    return $Saida;
}


/**************************************************************
  Funcao monta_relatorio_planilha_filas_dia
 *************************************************************/
function monta_relatorio_planilha_filas_dia($Filas, $Dados, $De, $Aa, $Formato) {
    $TipoNs = config_geral('-', 'tipoNS');
    
    if (!$Filas) return "Erro";
    list ($data_d, $horario_d) = explode (' ', $De); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d);
    list ($data_a, $horario_a) = explode (' ', $Aa); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a);

    $ano_d = intval($ano_d, 10);
    $mes_d = intval($mes_d, 10);
    $dia_d = intval($dia_d, 10);
    $ano_a = intval($ano_a, 10);
    $mes_a = intval($mes_a, 10);
    $dia_a = intval($dia_a, 10);
    
    $Total = array(0,0,0,0,0,0,0,0,0);
    $Totaldiasmensais=array(31,29,31,30,31,30,31,31,30,31,30,31);
    $diaSemana = array('Domingo', 'Segunda', 'Ter&ccedil;a', 'Quarta', 'Quinta', 'Sexta', 'S&aacute;bado');

    $saida = "";
    $teste = "";

    //return print_r($Dados['Ano'][2017]['Mes'][3]['Dia'][2]);

    if ($Formato=="html") $saida .= '<table class="relat">';
    if ($Formato=="xls")  $saida .= '<tr><td class=xl24 width=64>';

    //Header
    $saida .= '<tr>';
    for($ano = $ano_d; $ano <= $ano_a; $ano++){
        for($mes = intval($mes_d,10); $mes <= intval($mes_a,10); $mes++){
            if($mes == $mes_d) $dia_d1 = intval($dia_d);
            else $dia_d1 = 1;
            if($mes == $mes_a) $dia_a1 = intval($dia_a,10);
            else $dia_a1 = $Totaldiasmensais[$mes-1];
            
            for($dia = $dia_d1; $dia <= $dia_a1; $dia++) {
                if($dia == $dia_d && $mes == $mes_d && $ano == $ano_d) {
                    if ($Formato=="html") $saida .= '<td class="relatT"></td>';
                    if ($Formato=="xls")  $saida .= '<td class=xl24 width=64></td>';
                }

                $data = date('Y-m-d', mktime(0, 0, 0, $mes, $dia, $ano));
                $nomeDiaSemana = $diaSemana[date('w', strtotime($data))];

                if ($Formato=="html") $saida .= '<td class="relatT">'.$nomeDiaSemana." (".$dia."/".$mes.")".'</td>';
                if ($Formato=="xls")  $saida .= '<td class=xl24 width=64>'.$nomeDiaSemana." (".$dia."/".$mes.")".'</td>';

                if($dia == $dia_a && $mes == $mes_a && $ano == $ano_a){
                    if($Formato=="html") $saida .= '<td class="relatT">Total Geral</td>';
                    if($Formato=="xls") $saida .= '<td class=xl24 width=64>Total Geral</td>';
                }
            }
        }
    }
    $saida .= '</tr>';

    //Body
    for($i = 0; $i < count($Filas); $i++){
        $saida .= '<tr>';

        for($ano = $ano_d; $ano <= $ano_a; $ano++){
            for($mes = intval($mes_d,10); $mes <= intval($mes_a,10); $mes++){
                if($mes == $mes_d) $dia_d1 = intval($dia_d);
                else $dia_d1 = 1;
                if($mes == $mes_a) $dia_a1 = intval($dia_a,10);
                else $dia_a1 = $Totaldiasmensais[$mes-1];
                
                for($dia = $dia_d1; $dia <= $dia_a1; $dia++) {
                    if($dia == $dia_d && $mes == $mes_d && $ano == $ano_d){
                        if($Formato=="html") $saida .= '<td class="relatT">'.$Filas[$i].'</td>';
                        if($Formato=="xls") $saida .= '<td class=xl24 width=64>'.$Filas[$i].'</td>';
                    }

                    $chamadasAtendidas = $Dados[$Filas[$i]]['Ano'][$ano]['Mes'][$mes]['Dia'][$dia]['Quantidade chamadas atendidas'];
                    $total[$Filas[$i]] += $chamadasAtendidas;
                    $totalPorDia['Ano'][$ano]['Mes'][$mes]['Dia'][$dia] += $chamadasAtendidas;

                    $saida .= '<td class="relat">'.$chamadasAtendidas.'</td>';

                    if($dia == $dia_a && $mes == $mes_a && $ano == $ano_a){
                        if($Formato=="html") $saida .= '<td class="relatT">'.$total[$Filas[$i]].'</td>';
                        if($Formato=="xls") $saida .= '<td class=xl24 width=64>'.$total[$Filas[$i]].'</td>';
                    }
                }
            }
        }

        $saida .= '</tr>';
    }

    //Footer
    $saida .= '<tr>';
    for($ano = $ano_d; $ano <= $ano_a; $ano++){
        for($mes = intval($mes_d,10); $mes <= intval($mes_a,10); $mes++){
            if($mes == $mes_d) $dia_d1 = intval($dia_d);
            else $dia_d1 = 1;
            if($mes == $mes_a) $dia_a1 = intval($dia_a,10);
            else $dia_a1 = $Totaldiasmensais[$mes-1];
            
            for($dia = $dia_d1; $dia <= $dia_a1; $dia++) {
                if($dia == $dia_d && $mes == $mes_d && $ano == $ano_d) {
                    if ($Formato=="html") $saida .= '<td class="relatT">Total Geral</td>';
                    if ($Formato=="xls")  $saida .= '<td class=xl24 width=64>Total Geral</td>';
                }

                $totalDia = $totalPorDia['Ano'][$ano]['Mes'][$mes]['Dia'][$dia];
                $totalTodosDias += $totalDia;

                if ($Formato=="html") $saida .= '<td class="relatT">'.$totalDia.'</td>';
                if ($Formato=="xls")  $saida .= '<td class=xl24 width=64>'.$totalDia.'</td>';

                if($dia == $dia_a && $mes == $mes_a && $ano == $ano_a){
                    if($Formato=="html") $saida .= '<td class="relatT">'.$totalTodosDias.'</td>';
                    if($Formato=="xls") $saida .= '<td class=xl24 width=64>'.$totalTodosDias.'</td>';
                }
            }
        }
    }
    $saida .= '</tr>';

    if ($Formato=="html") $saida .= "</table>";

    return $saida;
}

?>
